/*==============================================================================
This .do file imports digitized labor data from 1971-1997 editions of 
the Eurostat Regional Yearbook.

Note: Data typically refer to April of the year indicated.   

*=============================================================================*/

clear all
set more off

cd "$insheet_files/Eurostat Regional Yearbook"

*Note: Date refers to the edition of the Eurostat Regional Yearbook
 #delimit ;
local years "1971 1972 1973 1975 1977 1981 1983 1984 1985 1986 1987 1988 
		1989 1993 1994 1995 1996 1997" ; 
#delim cr

*-------------------------------------------------------------------------------
* 1. Import excel data 
*-------------------------------------------------------------------------------

foreach year in `years' {
	import excel using "EYB_Labor.xlsx", ///
	first clear sheet(`year') 
	
	gen UNEMP2 = LF - EMP 
	replace UNEMP = UNEMP2 if UNEMP==. & UNEMP2>0 
	quietly drop UNEMP2 

	tempfile eyb_`year'
	quietly save `eyb_`year'.dta'  
} 

*-------------------------------------------------------------------------------
* 2. Append dta-files
*-------------------------------------------------------------------------------
clear
foreach year in `years' {
		quietly append using `eyb_`year'.dta'
}

*-------------------------------------------------------------------------------
* 3. Take median if more than one observation per year
*-------------------------------------------------------------------------------
drop if nuts==""
collapse (median) LF EMP UNEMP (first) region_name, by(nuts year)

rename LF LF_eyb
rename EMP EMP_eyb
rename UNEMP UNEMP_eyb

sort nuts year
save "$dta_files/EYB_labor_1968_1996.dta", replace

